using System;
using System.Collections.Generic;
using System.Text;

namespace Intemi.InTrees
{
    #region TDIDT Algoritm elements
    public interface INodeTestGenerator : IIntemi
    {
        List<INodeTest> GenerateTests(IDataTable data, ref bool shouldTerminate);
        INodeTest GenerateBestTest(IDataTable data, INodeTestSelector testSelector, ref bool shouldTerminate);
    }

    public interface INodeTestSelector : IIntemi
    {
        INodeTest SelectTest(List<INodeTest> nodeTests, IDataTable dataTable, ref bool shouldTerminate);
        double RateTest(INodeTest nodeTests, IDataTable dataTable, ref bool shouldTerminate);
    }

    public interface IStoppingCriterion : IIntemi
    {
        bool Stop(IDataTable dataTable, List<INodeTest> nodeTests, ref bool shouldTerminate);
        bool Stop(IDataTable dataTable, ref bool shouldTerminate);
    }

    public interface ITargetSelector : IIntemi
    {
        int SelectTarget(IDataTable dataTable, int target, ref bool shouldTerminate);
    }
    #endregion 

    #region Pruning
    public interface IPruning : IIntemi
    {
        /// <summary>
        /// Przycina drzewo stosujc wedug kryteriw zawartych w konfiguracji przycinania
        /// </summary>
        /// <param name="tree">Drzewo do przycicia</param>
        /// <param name="config">Konfiguracja przycinania</param>
        /// <param name="shouldTerminate">Polecenie przerwania procedury</param>
        /// <returns>Przycite drzewo</returns>
        DecisionTree Prune(DecisionTree tree, IPruningConfiguration config, IDataTable trainDT, ref bool shouldTerminate);

        /// <summary>
        /// Wskazuje optymaln konfiguracj przycinania
        /// </summary>
        /// <param name="tables">Tablice zawierajce kongiguracj przycinania i osignite przez nie wyniki klasyfikacji</param>
        /// <param name="shouldTerminate">Polecenie przerwania procedury</param>
        /// <returns>Optymalna konfiguracja</returns>
        IPruningConfiguration SelectOptimalConfiguration(List<IPruningTable> tables, ref bool shouldTerminate);

        /// <summary>
        /// Przycina drzewo w rnych konfiguracjach i zwraca tablic zawierajc tego efekty
        /// </summary>
        /// <param name="tree">Drzewo</param>
        /// <param name="shouldTerminate">Polecenie przerwania procedury</param>
        /// <returns>Tablica zawierajca kongiguracj przycinania i osignite przez nie wyniki klasyfikacji</returns>
        IPruningTable BuildPruningTable(DecisionTree tree, IDataTable trainDT, IDataTable testDT, ref bool shouldTerminate);

    }

    public interface IPruningConfiguration
    {

    }

    public interface IPruningTable
    {
        //IPruningConfiguration Configuration {get;set;}
        //IPruningResult Result { get;set;}
    }
    #endregion

    public interface INodeTest : IIntemi
    {
        // List<IClassificationRule> NodeRules{get; set;}

        double TestRate { get;set;}


        void AddRule(IClassificationRule rule);
        IClassificationRule GetRule(int index);

        /// <summary>
        /// Zwraca ilo gazi powsta na skutek danego testu.
        /// </summary>
        /// <returns></returns>
        int SplitCount();


        /// <summary>
        /// Okrela do ktrego poddrzewa powstaego w wyniku testu naley dany wektor 
        /// </summary>
        /// <param name="data"></param>
        /// <param name="missing"></param>
        /// <param name="fi"></param>
        /// <returns>Numer poddrzewa (gazi)</returns>
        int SplitData(float[] data, bool[] missing, IFeaturesInfo fi, ref bool shouldTerminate);

        IDataTable[] SplitData(IDataTable dataTable, ref bool shouldTerminate);

        string ToString(int rule);
        string ToHtml(int rule);
        string ToString();
        string ToHtml();
    }

}
